{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitViatgeEnGlobus;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, MMSystem;

const
  MaximPosicionsViatge = 2048;

type
  TFormViatgeEnGlobus = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonEngegarPararGlobus: TSpeedButton;
    ImageGlobus0: TImage;
    ImageGlobus1: TImage;
    ImageGlobus2: TImage;
    ImageGlobus3: TImage;
    SpeedButtonCaixaEines: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButtonEngegarPararGlobusClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
    ComptadorPosicio:integer;
    CircuitGlobus:array[0..MaximPosicionsViatge] of integer;
    QuinGlobus:integer;
    ValorDetectat:integer;
    Procedure GlobusInvisibles;
    procedure PintarIntensitat;
  end;

var
  FormViatgeEnGlobus: TFormViatgeEnGlobus;

{************************************************}
IMPLEMENTATION
{************************************************}

Uses UnitEntradaSo, UnitCanviDeParametres, UnitTools;

{$R *.DFM}

procedure TFormViatgeEnGlobus.FormCreate(Sender: TObject);
var
  i:integer;
begin
  Top:=0;
  Left:=0;
  Width:=Screen.Width;
  ClientHeight:=Panel.Height+10+128+128;
  for i:=0 to MaximPosicionsViatge do CircuitGlobus[i]:=Panel.Height+128+128;
  ValorDetectat:=0;
end;

procedure TFormViatgeEnGlobus.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  //if (SpeedButtonEngegarParar.Caption='P') or (SpeedButtonEngegarPararGlobus.Caption='PG') then begin
  if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarPararGlobus.Down:=false;
    SpeedButtonEngegarPararGlobus.Enabled:=true;
  end;
end;

procedure TFormViatgeEnGlobus.SpeedButtonEngegarPararClick(Sender: TObject);
var
  i:integer;
begin
  //if SpeedButtonEngegarParar.Caption='E' then begin
  if SpeedButtonEngegarParar.Down then begin
    ComptadorPosicio:=ImageGlobus0.width+2;
    GlobusInvisibles;
    SpeedButtonEngegarParar.Caption:='P';
    SpeedButtonEngegarPararGlobus.Enabled:=false;
    for i:=0 to MaximPosicionsViatge do CircuitGlobus[i]:=Panel.Height+128+128;
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarPararGlobus.Enabled:=true;
  end;
end;

procedure TFormViatgeEnGlobus.SpeedButtonEngegarPararGlobusClick(Sender: TObject);
begin
  //if SpeedButtonEngegarPararGlobus.Caption='EG' then begin
  if SpeedButtonEngegarPararGlobus.Down then begin
    ComptadorPosicio:=0;
    SpeedButtonEngegarPararGlobus.Caption:='PG';
    SpeedButtonEngegarParar.Enabled:=false;
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
    GlobusInvisibles;
    ImageGlobus0.Left:=ComptadorPosicio;
    ImageGlobus0.Top:=Panel.Height+50+128;
    ImageGlobus0.Visible:=true;
    QuinGlobus:=0;
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarParar.Enabled:=true;
    GlobusInvisibles;
    ImageGlobus0.Visible:=true;
  end;
end;

Procedure TFormViatgeEnGlobus.GlobusInvisibles;
begin
  ImageGlobus0.Visible:=false;
  ImageGlobus1.Visible:=false;
  ImageGlobus2.Visible:=false;
  ImageGlobus3.Visible:=false;
end;

procedure TFormViatgeEnGlobus.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
begin
  if (SpeedButtonEngegarParar.Caption='E') and (SpeedButtonEngegarPararGlobus.Caption='EG') then exit;
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  ValorDetectat:=Max;
  //if SpeedButtonEngegarParar.Caption='P' then begin
  if SpeedButtonEngegarParar.Down then begin
    if (Max>=ValorMinim) and (Max<=ValorMaxim) then Max:=Panel.Height+128 else Max:=Panel.Height+128+128;
    for i:=ComptadorPosicio-IncrementX+1 to ComptadorPosicio do CircuitGlobus[i]:=Max;
    Repaint;
    Canvas.Pen.Color:=clRed;
    Canvas.MoveTo(ComptadorPosicio,Max);
    Canvas.LineTo(ComptadorPosicio-6,Max-6);
    Canvas.LineTo(ComptadorPosicio-6,Max+6);
    Canvas.LineTo(ComptadorPosicio,Max);
    ComptadorPosicio:=ComptadorPosicio+IncrementX;
    {
    if ComptadorPosicio+ImageGlobus0.Width<ClientWidth then begin
      Canvas.Pen.Color:=clBlue;
      Canvas.MoveTo(ComptadorPosicio,Panel.Height);
      Canvas.LineTo(ComptadorPosicio,ClientHeight);
    end;
    }
  end else begin
    ComptadorPosicio:=ComptadorPosicio+IncrementX;
    if (Max>=ValorMinim) and (Max<=ValorMaxim) then Max:=Panel.Height+50 else Max:=Panel.Height+50+128;
    GlobusInvisibles;
    PintarIntensitat;
    if (Max<CircuitGlobus[ComptadorPosicio]) and (Max<CircuitGlobus[ComptadorPosicio+ImageGlobus0.Width]) then begin
      QuinGlobus:=(QuinGlobus+1) mod 4;
      if QuinGlobus=0 then begin
        ImageGlobus0.Top:=Max;
        ImageGlobus0.Left:=ComptadorPosicio;
        ImageGlobus0.Visible:=true;
      end else if QuinGlobus=1 then begin
        ImageGlobus1.Top:=Max;
        ImageGlobus1.Left:=ComptadorPosicio;
        ImageGlobus1.Visible:=true;
      end else if QuinGlobus=2 then begin
        ImageGlobus2.Top:=Max;
        ImageGlobus2.Left:=ComptadorPosicio;
        ImageGlobus2.Visible:=true;
      end else if QuinGlobus=3 then begin
        ImageGlobus3.Top:=Max;
        ImageGlobus3.Left:=ComptadorPosicio;
        ImageGlobus3.Visible:=true;
      end;
    end else begin
      ComptadorPosicio:=ComptadorPosicio-IncrementX;
      if (Max>CircuitGlobus[ComptadorPosicio]) or (Max>CircuitGlobus[ComptadorPosicio+ImageGlobus0.Width]) then Max:=Panel.Height+128-ImageGlobus0.Height;
      ImageGlobus0.Left:=ComptadorPosicio;
      ImageGlobus0.Top:=Max;
      ImageGlobus0.Visible:=true;
      QuinGlobus:=0;
    end;
  end;
  if ComptadorPosicio+ImageGlobus0.Width+1>=ClientWidth then begin
    //if SpeedButtonEngegarPararGlobus.Caption='PG' then begin
    if SpeedButtonEngegarPararGlobus.Down then begin
      GlobusInvisibles;
      ImageGlobus0.Left:=ComptadorPosicio;
      ImageGlobus0.Top:=Max;
      ImageGlobus0.Visible:=true;
      QuinGlobus:=0;
    end;
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
    SpeedButtonEngegarParar.Enabled:=true;
    SpeedButtonEngegarPararGlobus.Caption:='EG';
    SpeedButtonEngegarPararGlobus.Down:=false;
    SpeedButtonEngegarPararGlobus.Enabled:=true;
  end else EntradaSo;
end;

procedure TFormViatgeEnGlobus.PintarIntensitat;
const
  y = 20;
var
  i,max:integer;
begin
  Canvas.Pen.Color:=RGB(128,0,0);
  Canvas.MoveTo(0,20+y);
  Canvas.LineTo(ValorMinim,20+y);
  Canvas.MoveTo(0,35+y);
  Canvas.LineTo(ValorMinim,35+y);
  i:=0;
  while i<=ValorMinim do begin
    Canvas.MoveTo(i,20+y);
    Canvas.LineTo(i,23+y);
    Canvas.MoveTo(i,35+y);
    Canvas.LineTo(i,32+y);
    i:=i+10;
  end;
  Canvas.Pen.Color:=RGB(0,128,0);
  Canvas.MoveTo(ValorMinim,20+y);
  Canvas.LineTo(ValorMaxim,20+y);
  Canvas.LineTo(ValorMaxim,35+y);
  Canvas.LineTo(ValorMinim,35+y);
  Canvas.LineTo(ValorMinim,20+y);
  while i<=ValorMaxim do begin
    Canvas.MoveTo(i,20+y);
    Canvas.LineTo(i,23+y);
    Canvas.MoveTo(i,35+y);
    Canvas.LineTo(i,32+y);
    i:=i+10;
  end;
  max:=128;
  if ValorMaxim<max then begin
    Canvas.Pen.Color:=RGB(128,0,0);
    Canvas.MoveTo(ValorMaxim,20+y);
    Canvas.LineTo(Max,20+y);
    Canvas.LineTo(Max,35+y);
    Canvas.LineTo(ValorMaxim,35+y);
    while i<=Max do begin
      Canvas.MoveTo(i,20+y);
      Canvas.LineTo(i,23+y);
      Canvas.MoveTo(i,35+y);
      Canvas.LineTo(i,32+y);
      i:=i+10;
    end;
  end;
  Canvas.Pen.Color:=RGB(255,255,255);
  Canvas.MoveTo(0,26+y);
  Canvas.LineTo(128,26+y);
  Canvas.MoveTo(0,27+y);
  Canvas.LineTo(128,27+y);
  Canvas.MoveTo(0,28+y);
  Canvas.LineTo(128,28+y);
  Canvas.MoveTo(0,29+y);
  Canvas.LineTo(128,29+y);
  Canvas.MoveTo(0,30+y);
  Canvas.LineTo(128,30+y);
  if (ValorDetectat<ValorMinim) or (ValorDetectat>ValorMaxim) then Canvas.Pen.Color:=RGB(255,0,0) else Canvas.Pen.Color:=RGB(0,255,0);
  Canvas.MoveTo(0,26+y);
  Canvas.LineTo(ValorDetectat,26+y);
  Canvas.MoveTo(0,27+y);
  Canvas.LineTo(ValorDetectat,27+y);
  Canvas.MoveTo(0,28+y);
  Canvas.LineTo(ValorDetectat,28+y);
  Canvas.MoveTo(0,29+y);
  Canvas.LineTo(ValorDetectat,29+y);
  Canvas.MoveTo(0,30+y);
  Canvas.LineTo(ValorDetectat,30+y);
end;

procedure TFormViatgeEnGlobus.FormPaint(Sender: TObject);
var
  i:integer;
begin
  PintarIntensitat;
  Canvas.Pen.Color:=RGB(128,0,0);
  Canvas.MoveTo(0,Panel.Height+128+128);
  if ClientWidth>MaximPosicionsViatge then ClientWidth:=MaximPosicionsViatge;
  for i:=0 to ClientWidth do Canvas.LineTo(i,CircuitGlobus[i])
end;


procedure TFormViatgeEnGlobus.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
  Repaint;
end;


procedure TFormViatgeEnGlobus.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormViatgeEnGlobus.FormMouseDown(Sender: TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
  end else begin
    if SpeedButtonEngegarParar.Down or SpeedButtonEngegarPararGlobus.Down then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
      SpeedButtonEngegarParar.Enabled:=true;
      SpeedButtonEngegarPararGlobus.Caption:='EG';
      SpeedButtonEngegarPararGlobus.Down:=false;
      SpeedButtonEngegarPararGlobus.Enabled:=true;
    end;
  end;
end;

end.
